from components.component_base import ComponentBase


class MethodNotOverriddenException(Exception):
    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f'Method {self.message} not overridden'
        else:
            return f'Method not overridden'


class InvalidComponentException(Exception):
    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return self.message
        else:
            return 'Invalid component used'
